package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithPackageStrategyTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithPackageStrategy> {
    private static final JooqMapper<CampaignWithPackageStrategy> MAPPER = createMapper();

    @Autowired
    CampaignWithPackageStrategyTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithPackageStrategy> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithPackageStrategy model) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, model);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithPackageStrategy>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public Class<CampaignWithPackageStrategy> getTypeClass() {
        return CampaignWithPackageStrategy.class;
    }

    private static JooqMapper<CampaignWithPackageStrategy> createMapper() {
        return JooqMapperBuilder.<CampaignWithPackageStrategy>builder()
                .map(property(CampaignWithPackageStrategy.ID, CAMPAIGNS.CID))
                .map(property(CampaignWithPackageStrategy.STRATEGY_ID, CAMPAIGNS.STRATEGY_ID))
                .build();
    }
}
