package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes;
import ru.yandex.direct.core.entity.campaign.model.PlacementType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.convertibleEnumSet;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithPlacementTypesTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithPlacementTypes> {
    private static final JooqMapper<CampaignWithPlacementTypes> MAPPER = createMapper();

    @Autowired
    public CampaignWithPlacementTypesTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithPlacementTypes> getTypeClass() {
        return CampaignWithPlacementTypes.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMP_OPTIONS,
                JoinType.LEFT_OUTER_JOIN,
                CAMP_OPTIONS.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public void fillFromRecord(CampaignWithPlacementTypes campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithPlacementTypes>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithPlacementTypes campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    private static JooqMapper<CampaignWithPlacementTypes> createMapper() {
        return JooqMapperBuilder.<CampaignWithPlacementTypes>builder()
                .map(property(CampaignWithPlacementTypes.ID, CAMP_OPTIONS.CID))
                .map(convertibleEnumSet(CampaignWithPlacementTypes.PLACEMENT_TYPES, CAMP_OPTIONS.PLACEMENT_TYPES,
                        PlacementType::fromTypedValue, PlacementType::getTypedValue))
                .build();
    }
}
