package ru.yandex.direct.core.entity.campaign.repository.type

import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPromoExtension
import ru.yandex.direct.multitype.entity.JoinQuery
import org.jooq.DSLContext
import org.jooq.JoinType
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.write.WriterBuilders
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders
import ru.yandex.direct.jooqmapperhelper.InsertHelper

@Component
class CampaignWithPromoExtensionRepositoryTypeSupport(
    dslContextProvider: DslContextProvider
) : AbstractCampaignRepositoryTypeSupport<CampaignWithPromoExtension>(dslContextProvider) {
    companion object {
        private val MAPPER = JooqMapperBuilder.builder<CampaignWithPromoExtension>()
            .writeField(Tables.CAMPAIGN_PROMOACTIONS.CID, WriterBuilders.fromProperty(CampaignWithPromoExtension.ID))
            .map(ReaderWriterBuilders.property(CampaignWithPromoExtension.PROMO_EXTENSION_ID, Tables.CAMPAIGN_PROMOACTIONS.PROMOACTION_ID))
            .build()

    }

    override fun getTypeClass() = CampaignWithPromoExtension::class.java

    override fun getFields() = MAPPER.fieldsToRead

    override fun joinQuery() = listOf(
        JoinQuery(
            Tables.CAMPAIGN_PROMOACTIONS,
            JoinType.LEFT_OUTER_JOIN,
            Tables.CAMPAIGN_PROMOACTIONS.CID.eq(Tables.CAMPAIGNS.CID)
        )
    )

    override fun <M : CampaignWithPromoExtension> fillFromRecord(campaign: M, record: Record) {
        MAPPER.fromDb(record, campaign)
    }

    override fun updateAdditionTables(
        context: DSLContext,
        updateParameters: RestrictedCampaignsUpdateOperationContainer,
        appliedChanges: Collection<AppliedChanges<CampaignWithPromoExtension>>
    ) {
        val idsToDelete = appliedChanges
            .filter { it.deleted(CampaignWithPromoExtension.PROMO_EXTENSION_ID) }
            .map { it.model.id }
        if (idsToDelete.isNotEmpty()) {
            context.deleteFrom(Tables.CAMPAIGN_PROMOACTIONS).where(Tables.CAMPAIGN_PROMOACTIONS.CID.`in`(idsToDelete)).execute()
        }
        val modelsToAdd = appliedChanges
            .filter { it.assigned(CampaignWithPromoExtension.PROMO_EXTENSION_ID) }
            .map { it.model }
        if (modelsToAdd.isNotEmpty()) {
            InsertHelper(context, Tables.CAMPAIGN_PROMOACTIONS)
                .addAll(MAPPER, modelsToAdd)
                .execute()
        }
    }

    override fun pushToInsert(
        insertHelperAggregator: InsertHelperAggregator,
        model: CampaignWithPromoExtension
    ) {
        if (model.promoExtensionId != null) {
            insertHelperAggregator.getOrCreate(Tables.CAMPAIGN_PROMOACTIONS).add(MAPPER, model)
        }
    }

    override fun processUpdate(
        updateHelperAggregator: UpdateHelperAggregator,
        appliedChanges: Collection<AppliedChanges<CampaignWithPromoExtension>>
    ) {
        updateHelperAggregator
            .getOrCreate(Tables.CAMPAIGN_PROMOACTIONS.CID)
            .processUpdateAll(MAPPER, appliedChanges
                .filter { it.replaced(CampaignWithPromoExtension.PROMO_EXTENSION_ID) }
        )
    }
}
