package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithRecommendationsManagement;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRecommendationsManagementTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithRecommendationsManagement> {

    private static final JooqReader<CampaignWithRecommendationsManagement> READER = createReader();

    @Autowired
    public CampaignWithRecommendationsManagementTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithRecommendationsManagement> getTypeClass() {
        return CampaignWithRecommendationsManagement.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithRecommendationsManagement campaign, Record record1) {
        READER.fromDb(record1, campaign);
    }

    @SuppressWarnings("java:S3252")
    private static JooqReader<CampaignWithRecommendationsManagement> createReader() {
        return JooqReaderBuilder.<CampaignWithRecommendationsManagement>builder()
                .readProperty(CampaignWithRecommendationsManagement.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isRecommendationsManagementEnabled))
                .readProperty(CampaignWithRecommendationsManagement.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isPriceRecommendationsManagementEnabled))
                .build();
    }
}
