package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithSimplifiedStrategyView;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSimplifiedStrategyViewTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithSimplifiedStrategyView> {
    private static final JooqReader<CampaignWithSimplifiedStrategyView> READER = createReader();

    @Autowired
    public CampaignWithSimplifiedStrategyViewTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithSimplifiedStrategyView> void fillFromRecord(M campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithSimplifiedStrategyView> getTypeClass() {
        return CampaignWithSimplifiedStrategyView.class;
    }

    private static JooqReader<CampaignWithSimplifiedStrategyView> createReader() {
        return JooqReaderBuilder.<CampaignWithSimplifiedStrategyView>builder()
                .readProperty(CampaignWithSimplifiedStrategyView.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isSimplifiedStrategyViewEnabled))
                .build();
    }
}
