package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Field
import org.jooq.JoinType
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithSourceId
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.Tables.CURRENCY_CONVERT_MONEY_CORRESPONDENCE
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property
import ru.yandex.direct.multitype.entity.JoinQuery

@Component
class CampaignWithSourceIdTypeSupport(
    dslContextProvider: DslContextProvider
) : AbstractCampaignRepositoryTypeSupport<CampaignWithSourceId>(
    dslContextProvider
) {
    override fun getFields(): Collection<Field<*>> = mapper.fieldsToRead

    override fun joinQuery(): List<JoinQuery> = listOf(
        JoinQuery(
            CURRENCY_CONVERT_MONEY_CORRESPONDENCE,
            JoinType.LEFT_OUTER_JOIN,
            CURRENCY_CONVERT_MONEY_CORRESPONDENCE.NEW_CID.eq(CAMPAIGNS.CID)
                .and(CURRENCY_CONVERT_MONEY_CORRESPONDENCE.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
        )
    )

    override fun <M : CampaignWithSourceId> fillFromRecord(model: M, record: Record) {
        mapper.fromDb(record, model)
    }

    override fun getTypeClass(): Class<CampaignWithSourceId> = CampaignWithSourceId::class.java

    private companion object {
        private val mapper = JooqMapperBuilder
            .builder<CampaignWithSourceId>()
            .map(property(CampaignWithSourceId.SOURCE_ID, CURRENCY_CONVERT_MONEY_CORRESPONDENCE.OLD_CID))
            .build()
    }
}
