package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Record
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.core.entity.campaign.model.CampaignWithSource
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignWithSourceRepositoryTypeSupport @Autowired constructor(dslContextProvider: DslContextProvider) :
        AbstractCampaignRepositoryTypeSupport<CampaignWithSource>(dslContextProvider) {

    companion object {
        private val MAPPER = JooqMapperBuilder.builder<CampaignWithSource>()
            .map(convertibleProperty(CommonCampaign.SOURCE, CAMPAIGNS.SOURCE, CampaignSource::fromSource,
                CampaignSource::toSource))
            .build()
    }

    override fun getFields() = listOf(Tables.CAMPAIGNS.SOURCE)

    override fun <M : CampaignWithSource> fillFromRecord(campaign: M, record: Record) {
        MAPPER.fromDb(record, campaign)
    }

    override fun getTypeClass() = CampaignWithSource::class.java

}
