package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Field
import org.jooq.JoinType
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.common.util.RepositoryUtils
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStopTime
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property
import ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField
import ru.yandex.direct.jooqmapper.write.WriterBuilders.fromPropertyToField
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.multitype.entity.JoinQuery

@Component
class CampaignWithStopTimeTypeSupport(
    dslContextProvider: DslContextProvider,
) : AbstractCampaignRepositoryTypeSupport<CampaignWithStopTime>(
    dslContextProvider,
) {
    override fun getTypeClass() = CampaignWithStopTime::class.java

    override fun getFields(): Collection<Field<*>> = mapper.fieldsToRead

    override fun <M : CampaignWithStopTime> fillFromRecord(model: M, record: Record) {
        mapper.fromDb(record, model)
    }

    override fun joinQuery(): List<JoinQuery> =
        listOf(
            JoinQuery(
                CAMP_OPTIONS,
                JoinType.LEFT_OUTER_JOIN,
                CAMP_OPTIONS.CID.eq(CAMPAIGNS.CID)
            ),
        )

    override fun processUpdate(
        updateHelperAggregator: UpdateHelperAggregator,
        appliedChanges: Collection<AppliedChanges<CampaignWithStopTime>>
    ) {
        updateHelperAggregator
            .getOrCreate(CAMP_OPTIONS.CID)
            .processUpdateAll(mapper, appliedChanges)
    }

    override fun pushToInsert(
        insertHelperAggregator: InsertHelperAggregator,
        campaign: CampaignWithStopTime
    ) {
        insertHelperAggregator
            .getOrCreate(CAMP_OPTIONS)
            .add(mapper, campaign)
    }

    private companion object {
        private val mapper = JooqMapperBuilder.builder<CampaignWithStopTime>()
            .map(property(CampaignWithStopTime.ID, CAMPAIGNS.CID))
            .readProperty(CampaignWithStopTime.STOP_TIME, fromField(CAMP_OPTIONS.STOP_TIME))
            .writeField(
                CAMP_OPTIONS.STOP_TIME, fromPropertyToField(CampaignWithStopTime.STOP_TIME)
                    .by(RepositoryUtils::zeroableDateTimeToDb)
            )
            .build()
    }
}
