package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTimeTargeting;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTimeTargetingTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithTimeTargeting> {

    private static final JooqMapper<CampaignWithTimeTargeting> MAPPER = createMapper();

    @Autowired
    protected CampaignWithTimeTargetingTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithTimeTargeting> getTypeClass() {
        return CampaignWithTimeTargeting.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithTimeTargeting> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithTimeTargeting>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithTimeTargeting campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }


    private static JooqMapper<CampaignWithTimeTargeting> createMapper() {
        return JooqMapperBuilder.<CampaignWithTimeTargeting>builder()
                .map(convertibleProperty(CampaignWithTimeTargeting.TIME_TARGET, CAMPAIGNS.TIME_TARGET,
                        CampaignMappings::timeTargetFromDb, CampaignMappings::timeTargetToDb))
                .map(property(CampaignWithTimeTargeting.TIME_ZONE_ID, CAMPAIGNS.TIMEZONE_ID))
                .build();
    }

}
