package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithWidgetPartnerId;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.WIDGET_PARTNER_CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public final class CampaignWithWidgetPartnerIdTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithWidgetPartnerId> {
    private final JooqMapper<CampaignWithWidgetPartnerId> jooqMapper = JooqMapperBuilder
            .<CampaignWithWidgetPartnerId>builder()
            .writeField(WIDGET_PARTNER_CAMPAIGNS.CID, fromProperty(CampaignWithWidgetPartnerId.ID))
            .map(property(CampaignWithWidgetPartnerId.WIDGET_PARTNER_ID, WIDGET_PARTNER_CAMPAIGNS.WIDGET_PARTNER_ID))
            .build();

    CampaignWithWidgetPartnerIdTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return jooqMapper.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithWidgetPartnerId> void fillFromRecord(M model, Record record) {
        jooqMapper.fromDb(record, model);
    }

    @Override
    public Class<CampaignWithWidgetPartnerId> getTypeClass() {
        return CampaignWithWidgetPartnerId.class;
    }

    @Override
    public void insertToAdditionTables(
            DSLContext context,
            RestrictedCampaignsAddOperationContainer addModelParametersContainer,
            Collection<CampaignWithWidgetPartnerId> models
    ) {
        final var modelsWithWidgetPartnerId = models
                .stream()
                .filter(m -> m.getWidgetPartnerId() != null && m.getSource() == CampaignSource.WIDGET)
                .collect(Collectors.toList());

        if (modelsWithWidgetPartnerId.size() == 0) {
            return;
        }

        final var helper = new InsertHelper<>(context, WIDGET_PARTNER_CAMPAIGNS);
        helper.addAll(jooqMapper, modelsWithWidgetPartnerId);

        if (helper.hasAddedRecords()) {
            helper.onDuplicateKeyUpdate()
                    .set(WIDGET_PARTNER_CAMPAIGNS.WIDGET_PARTNER_ID, MySQLDSL.values(WIDGET_PARTNER_CAMPAIGNS.WIDGET_PARTNER_ID));
        }

        helper.executeIfRecordsAdded();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(
                WIDGET_PARTNER_CAMPAIGNS,
                JoinType.LEFT_OUTER_JOIN,
                WIDGET_PARTNER_CAMPAIGNS.CID.eq(CAMPAIGNS.CID)
        ));
    }
}
