package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithWwManagedOrderFlag;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithWwManagedOrderFlagTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithWwManagedOrderFlag> {
    private static final JooqReader<CampaignWithWwManagedOrderFlag> READER = createReader();

    @Autowired
    CampaignWithWwManagedOrderFlagTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithWwManagedOrderFlag> void fillFromRecord(M campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithWwManagedOrderFlag> getTypeClass() {
        return CampaignWithWwManagedOrderFlag.class;
    }

    private static JooqReader<CampaignWithWwManagedOrderFlag> createReader() {
        return JooqReaderBuilder.<CampaignWithWwManagedOrderFlag>builder()
                .readProperty(CampaignWithWwManagedOrderFlag.IS_WW_MANAGED_ORDER,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isWwManagedOrder))
                .build();
    }
}
