package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.core.entity.campaign.model.RfCloseByClickType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.integerProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignTypeSupport extends AbstractCampaignRepositoryTypeSupport<InternalCampaign> {

    private static final JooqMapper<InternalCampaign> MAPPER =
            JooqMapperBuilder.<InternalCampaign>builder()
                    .map(property(InternalCampaign.ID, CAMPAIGNS_INTERNAL.CID))
                    .map(property(InternalCampaign.PLACE_ID, CAMPAIGNS_INTERNAL.PLACE_ID))
                    .map(convertibleProperty(InternalCampaign.PAGE_ID, CAMPAIGNS_INTERNAL.PAGE_IDS,
                            InternalCampaignTypeSupport::pageIdsFromDb,
                            InternalCampaignTypeSupport::pageIdsToDb))
                    .map(convertibleProperty(InternalCampaign.IS_MOBILE, CAMPAIGNS_INTERNAL.IS_MOBILE,
                            RepositoryUtils::booleanFromLong, RepositoryUtils::booleanToLong))
                    .map(convertibleProperty(InternalCampaign.RF_CLOSE_BY_CLICK, CAMPAIGNS_INTERNAL.RF_CLOSE_BY_CLICK,
                            RfCloseByClickType::fromSource, RfCloseByClickType::toSource))
                    .map(integerProperty(InternalCampaign.MAX_CLICKS_COUNT, CAMPAIGNS_INTERNAL.MAX_CLICKS_COUNT))
                    .map(integerProperty(InternalCampaign.MAX_CLICKS_PERIOD, CAMPAIGNS_INTERNAL.MAX_CLICKS_PERIOD))
                    .map(integerProperty(InternalCampaign.MAX_STOPS_COUNT, CAMPAIGNS_INTERNAL.MAX_STOPS_COUNT))
                    .map(integerProperty(InternalCampaign.MAX_STOPS_PERIOD, CAMPAIGNS_INTERNAL.MAX_STOPS_PERIOD))
                    .build();

    @Autowired
    public InternalCampaignTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMPAIGNS_INTERNAL, JoinType.LEFT_OUTER_JOIN,
                CAMPAIGNS_INTERNAL.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public <M extends InternalCampaign> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
        // ещё какие-то действия над полями делаются в других TypeSupport-ах на InternalCampaign
    }

    @Override
    public Class<InternalCampaign> getTypeClass() {
        return InternalCampaign.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, InternalCampaign campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL).add(MAPPER, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<InternalCampaign>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    public static List<Long> pageIdsFromDb(@Nullable String dbValue) {
        if (StringUtils.isEmpty(dbValue)) {
            return Collections.emptyList();
        }

        return StreamEx.split(dbValue, ",").map(Long::parseLong).toList();
    }

    private static String pageIdsToDb(List<Long> modelValue) {
        return StreamEx.of(modelValue).map(Object::toString).joining(",");
    }

}
