package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignRestrictionType;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRestriction;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithRestrictionTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<InternalCampaignWithRestriction> {

    private static final JooqMapper<InternalCampaignWithRestriction> MAPPER =
            JooqMapperBuilder.<InternalCampaignWithRestriction>builder()
                    .map(property(InternalCampaignWithRestriction.ID, CAMPAIGNS_INTERNAL.CID))
                    .map(property(InternalCampaignWithRestriction.RESTRICTION_VALUE,
                            CAMPAIGNS_INTERNAL.RESTRICTION_VALUE))
                    .map(convertibleProperty(InternalCampaignWithRestriction.RESTRICTION_TYPE,
                            CAMPAIGNS_INTERNAL.RESTRICTION_TYPE,
                            InternalCampaignRestrictionType::fromSource,
                            InternalCampaignRestrictionType::toSource))
                    .build();

    @Autowired
    public InternalCampaignWithRestrictionTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMPAIGNS_INTERNAL, JoinType.LEFT_OUTER_JOIN,
                CAMPAIGNS_INTERNAL.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public <M extends InternalCampaignWithRestriction> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<InternalCampaignWithRestriction> getTypeClass() {
        return InternalCampaignWithRestriction.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             InternalCampaignWithRestriction campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL).add(MAPPER, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<InternalCampaignWithRestriction>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL.CID).processUpdateAll(MAPPER, appliedChanges);
    }

}
