package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRotationGoalId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_INTERNAL;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithRotationGoalIdTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<InternalCampaignWithRotationGoalId> {

    private static final JooqMapper<InternalCampaignWithRotationGoalId> MAPPER =
            JooqMapperBuilder.<InternalCampaignWithRotationGoalId>builder()
                    .map(property(InternalCampaignWithRotationGoalId.ID, CAMPAIGNS_INTERNAL.CID))
                    .map(property(InternalCampaignWithRotationGoalId.ROTATION_GOAL_ID,
                            CAMPAIGNS_INTERNAL.ROTATION_GOAL_ID))
                    .build();

    @Autowired
    public InternalCampaignWithRotationGoalIdTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMPAIGNS_INTERNAL, JoinType.LEFT_OUTER_JOIN,
                CAMPAIGNS_INTERNAL.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public <M extends InternalCampaignWithRotationGoalId> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<InternalCampaignWithRotationGoalId> getTypeClass() {
        return InternalCampaignWithRotationGoalId.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             InternalCampaignWithRotationGoalId campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL).add(MAPPER, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<InternalCampaignWithRotationGoalId>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS_INTERNAL.CID).processUpdateAll(MAPPER, appliedChanges);
    }

}
