package ru.yandex.direct.core.entity.campaign.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCreatingEmptyStatForGoals;
import ru.yandex.direct.core.entity.campaign.model.WithMetrikaCounters;
import ru.yandex.direct.core.entity.metrika.service.MetrikaGoalsService;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@Service
public class CampMetrikaGoalsService {

    private final MetrikaGoalsService metrikaGoalsService;

    @Autowired
    public CampMetrikaGoalsService(MetrikaGoalsService metrikaGoalsService) {
        this.metrikaGoalsService = metrikaGoalsService;
    }

    public void addCampMetrikaGoals(int shard, ClientId clientId,
                                    List<CampaignWithCreatingEmptyStatForGoals> campaignsToUpdateGoals,
                                    Map<Long, Set<Goal>> goalsByCounterId) {

        Map<Long, Set<Long>> goalIdsByCounterId = EntryStream.of(goalsByCounterId)
                .mapValues(goals -> mapSet(goals, Goal::getId))
                .toMap();

        Map<Long, Set<Long>> goalIdsToAddByCampaignId = StreamEx.of(campaignsToUpdateGoals)
                .mapToEntry(BaseCampaign::getId, WithMetrikaCounters::getMetrikaCounters)
                .flatMapValues(Collection::stream)
                .mapValues(goalIdsByCounterId::get)
                .nonNullValues()
                .flatMapValues(Collection::stream)
                .grouping(Collectors.toSet());

        metrikaGoalsService.addCampMetrikaGoals(shard, clientId, goalIdsToAddByCampaignId);

        Set<Goal> goalsToUpdate = goalsByCounterId.values().stream()
                .flatMap(Set::stream)
                .collect(Collectors.toSet());

        metrikaGoalsService.addMetrikaGoals(goalsToUpdate);
    }
}
