package ru.yandex.direct.core.entity.campaign.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignModifyRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.campaign.service.type.add.CampaignAddOperationSupportFacade;
import ru.yandex.direct.core.entity.campaign.service.type.update.CampaignUpdateOperationSupportFacade;
import ru.yandex.direct.core.entity.campaign.service.validation.AddRestrictedCampaignValidationService;
import ru.yandex.direct.core.entity.campaign.service.validation.UpdateRestrictedCampaignValidationService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.retargeting.service.common.GoalUtilsService;
import ru.yandex.direct.core.entity.strategy.repository.StrategyTypedRepository;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.model.UidClientIdShard;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.rbac.RbacService;

@Service
@ParametersAreNonnullByDefault
public class CampaignOperationService {
    private final ShardHelper shardHelper;
    private final DslContextProvider ppcDslContextProvider;
    private final RbacService rbacService;

    private final CampaignTypedRepository campaignTypedRepository;
    private final CampaignModifyRepository campaignModifyRepository;
    private final StrategyTypedRepository strategyTypedRepository;

    private final CampaignUpdateOperationSupportFacade campaignUpdateOperationSupportFacade;
    private final CampaignAddOperationSupportFacade campaignAddOperationSupportFacade;

    private final UpdateRestrictedCampaignValidationService updateRestrictedCampaignValidationService;
    private final AddRestrictedCampaignValidationService addRestrictedCampaignValidationService;
    private final CampaignAdditionalActionsService campaignAdditionalActionsService;

    private final RequestBasedMetrikaClientFactory metrikaClientFactory;
    private final FeatureService featureService;
    private final GoalUtilsService goalUtilsService;

    public CampaignOperationService(ShardHelper shardHelper,
                                    RbacService rbacService, CampaignTypedRepository campaignTypedRepository,
                                    CampaignModifyRepository campaignModifyRepository,
                                    StrategyTypedRepository strategyTypedRepository,
                                    DslContextProvider ppcDslContextProvider,
                                    CampaignUpdateOperationSupportFacade campaignUpdateOperationSupportFacade,
                                    CampaignAddOperationSupportFacade campaignAddOperationSupportFacade,
                                    UpdateRestrictedCampaignValidationService updateRestrictedCampaignValidationService,
                                    AddRestrictedCampaignValidationService addRestrictedCampaignValidationService,
                                    CampaignAdditionalActionsService campaignAdditionalActionsService,
                                    RequestBasedMetrikaClientFactory metrikaClientFactory,
                                    FeatureService featureService,
                                    GoalUtilsService goalUtilsService) {
        this.shardHelper = shardHelper;
        this.rbacService = rbacService;
        this.campaignTypedRepository = campaignTypedRepository;
        this.strategyTypedRepository = strategyTypedRepository;
        this.campaignModifyRepository = campaignModifyRepository;
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.campaignUpdateOperationSupportFacade = campaignUpdateOperationSupportFacade;
        this.campaignAddOperationSupportFacade = campaignAddOperationSupportFacade;
        this.updateRestrictedCampaignValidationService = updateRestrictedCampaignValidationService;
        this.addRestrictedCampaignValidationService = addRestrictedCampaignValidationService;
        this.campaignAdditionalActionsService = campaignAdditionalActionsService;
        this.metrikaClientFactory = metrikaClientFactory;
        this.featureService = featureService;
        this.goalUtilsService = goalUtilsService;
    }

    public RestrictedCampaignsUpdateOperation createRestrictedCampaignUpdateOperation(
            List<? extends ModelChanges<? extends BaseCampaign>> modelChanges,
            Long operatorUid,
            UidAndClientId uidAndClientId,
            CampaignOptions options) {
        return createRestrictedCampaignUpdateOperation(modelChanges, operatorUid, uidAndClientId,
                Applicability.PARTIAL, options);
    }

    public RestrictedCampaignsUpdateOperation createRestrictedCampaignUpdateOperation(
            List<? extends ModelChanges<? extends BaseCampaign>> modelChanges,
            Long operatorUid,
            UidAndClientId uidAndClientId,
            Applicability applicability,
            CampaignOptions options) {
        int shard = shardHelper.getShardByClientIdStrictly(uidAndClientId.getClientId());

        return new RestrictedCampaignsUpdateOperation(modelChanges, operatorUid,
                UidClientIdShard.of(uidAndClientId.getUid(), uidAndClientId.getClientId(), shard),
                campaignModifyRepository, campaignTypedRepository, strategyTypedRepository,
                updateRestrictedCampaignValidationService,
                campaignUpdateOperationSupportFacade, campaignAdditionalActionsService, ppcDslContextProvider,
                rbacService, metrikaClientFactory, featureService, applicability, options);
    }

    public RestrictedCampaignsAddOperation createRestrictedCampaignAddOperation(
            List<? extends BaseCampaign> campaigns, Long operatorUid,
            UidAndClientId uidAndClientId, CampaignOptions options) {
        int shard = shardHelper.getShardByClientIdStrictly(uidAndClientId.getClientId());

        return new RestrictedCampaignsAddOperation(campaigns, shard, uidAndClientId, operatorUid,
                campaignModifyRepository, strategyTypedRepository, addRestrictedCampaignValidationService,
                campaignAddOperationSupportFacade, ppcDslContextProvider, rbacService, options, metrikaClientFactory,
                goalUtilsService);
    }

}
