package ru.yandex.direct.core.entity.campaign.service

/**
 * Настройки операций add и update кампаний
 * Настройки общие для add и update, но некоторые могут использовать только в add или только в update.
 * Разбить на add и update затруднительно из-за обширного использования CampaignValidationContainer,
 * смотри также https://st.yandex-team.ru/DIRECT-128097#616b26d3ff7e326046ae8758
 */
class CampaignOptions(
    val isCopy: Boolean = false,
    val isCopyInOneClient: Boolean = false,
    val skipValidateMobileApp: Boolean = false,
    val isReadyToModerate: Boolean = false,
    val keepModerationStatuses: Boolean = false,
    val isForceEnableCheckPositionEvent: Boolean = false,
    val isForceCheckPositionIntervalEvent: Boolean = false,
    val isAllowNullDeviceTypeTargeting: Boolean = false,
    val isAllowNullNetworkTargeting: Boolean = false,
    val isAllowZeroMobileAppId: Boolean = false,
    val requireServicing: List<Boolean?>? = null,
    val isLimitFioTo255Chars: Boolean = false,
    val isValidateFioForForbiddenChars: Boolean = false,
    val isValidateCampaignNameForForbiddenChars: Boolean = false,
    val isForceValidateAvgCpmMin: Boolean = false,
    val isSendAutoServicingMailNotification: Boolean = false,
    val isValidatePayForConversionExtendedModeEnabled: Boolean = false,
    val isValidatePayForConversionInAutobudgetAvgCpaPerFilter: Boolean = false,
    val isCheckDisableAllGoalsOptimizationForDnaFeature: Boolean = false,
    val isFetchMetrikaCountersForGoals: Boolean = false,
    val isFromStrategyOperation: Boolean = false,
    val isAllowAllGoalsOptimizationForOldCampaigns: Boolean = false,
    val isCheckStrategyForMeaninfulGoalsGoalId: Boolean = false,
    val isAutoApply: Boolean = false,
) {
    class Builder {
        internal var isCopy = false
        internal var isCopyInOneClient = false
        internal var skipValidateMobileApp = false
        internal var readyToModerate = false
        internal var keepModerationStatuses = false
        internal var forceEnableCheckPositionEvent = false
        internal var forceCheckPositionIntervalEvent = false
        internal var allowNullDeviceTypeTargeting = false
        internal var allowNullNetworkTargeting = false
        internal var allowZeroMobileAppId = false
        internal var requireServicing: List<Boolean?>? = null
        internal var limitFioTo255Chars = false
        internal var validateFioForForbiddenChars = false
        internal var validateCampaignNameForForbiddenChars = false
        internal var forceValidateAvgCpmMin = false
        internal var sendAutoServicingMailNotification = false
        internal var validatePayForConversionExtendedModeEnabled = false
        internal var validatePayForConversionInAutobudgetAvgCpaPerFilter = false
        internal var checkDisableAllGoalsOptimizationForDnaFeature = false
        internal var fetchMetrikaCountersForGoals = false
        internal var isFromStrategyOperation: Boolean = false
        internal var isAllowAllGoalsOptimizationForOldCampaigns: Boolean = false
        internal var isCheckStrategyForMeaninfulGoalsGoalId: Boolean = false
        internal var isAutoApply: Boolean = false

        fun withCopy(copy: Boolean): Builder {
            isCopy = copy
            return this
        }

        fun withCopyInOneClient(copyInOneClient: Boolean): Builder {
            isCopyInOneClient = copyInOneClient
            return this
        }

        fun withSkipValidateMobileApp(skipValidateMobileApp: Boolean): Builder {
            this.skipValidateMobileApp = skipValidateMobileApp
            return this
        }

        fun withReadyToModerate(readyToModerate: Boolean): Builder {
            this.readyToModerate = readyToModerate
            return this
        }

        fun withKeepModerationStatuses(keepModerationStatuses: Boolean): Builder {
            this.keepModerationStatuses = keepModerationStatuses
            return this
        }

        fun withForceEnableCheckPositionEvent(forceEnableCheckPositionEvent: Boolean): Builder {
            this.forceEnableCheckPositionEvent = forceEnableCheckPositionEvent
            return this
        }

        fun withForceCheckPositionIntervalEvent(forceCheckPositionIntervalEvent: Boolean): Builder {
            this.forceCheckPositionIntervalEvent = forceCheckPositionIntervalEvent
            return this
        }

        fun withAllowNullDeviceTypeTargeting(allowNullDeviceTypeTargeting: Boolean): Builder {
            this.allowNullDeviceTypeTargeting = allowNullDeviceTypeTargeting
            return this
        }

        fun withAllowNullNetworkTargeting(allowNullNetworkTargeting: Boolean): Builder {
            this.allowNullNetworkTargeting = allowNullNetworkTargeting
            return this
        }

        fun withAllowZeroMobileAppId(allowZeroMobileAppId: Boolean): Builder {
            this.allowZeroMobileAppId = allowZeroMobileAppId
            return this
        }

        fun withRequireServicing(requireServicing: List<Boolean?>?): Builder {
            this.requireServicing = requireServicing
            return this
        }

        fun withLimitFioTo255Chars(limitFioTo255Chars: Boolean): Builder {
            this.limitFioTo255Chars = limitFioTo255Chars
            return this
        }

        fun withValidateFioForForbiddenChars(validateFioForForbiddenChars: Boolean): Builder {
            this.validateFioForForbiddenChars = validateFioForForbiddenChars
            return this
        }

        fun withValidateCampaignNameForForbiddenChars(validateCampaignNameForForbiddenChars: Boolean): Builder {
            this.validateCampaignNameForForbiddenChars = validateCampaignNameForForbiddenChars
            return this
        }

        fun withForceValidateAvgCpmMin(forceValidateAvgCpmMin: Boolean): Builder {
            this.forceValidateAvgCpmMin = forceValidateAvgCpmMin
            return this
        }

        fun withSendAutoServicingMailNotification(sendAutoServicingMailNotification: Boolean): Builder {
            this.sendAutoServicingMailNotification = sendAutoServicingMailNotification
            return this
        }

        fun withValidatePayForConversionExtendedModeEnabled(
            validatePayForConversionExtendedModeEnabled: Boolean
        ): Builder {
            this.validatePayForConversionExtendedModeEnabled = validatePayForConversionExtendedModeEnabled
            return this
        }

        /**
         * https://a.yandex-team.ru/arc_vcs/direct/perl/protected/Direct/Validation/Strategy.pm?rev=r8814824#L704
         */
        fun withValidatePayForConversionInAutobudgetAvgCpaPerFilter(
            validatePayForConversionInAutobudgetAvgCpaPerFilter: Boolean
        ): Builder {
            this.validatePayForConversionInAutobudgetAvgCpaPerFilter =
                validatePayForConversionInAutobudgetAvgCpaPerFilter
            return this
        }

        fun withCheckDisableAllGoalsOptimizationForDnaFeature(
            checkDisableAllGoalsOptimizationForDnaFeature: Boolean
        ): Builder {
            this.checkDisableAllGoalsOptimizationForDnaFeature = checkDisableAllGoalsOptimizationForDnaFeature
            return this
        }

        fun withFetchMetrikaCountersForGoals(fetchMetrikaCountersForGoals: Boolean): Builder {
            this.fetchMetrikaCountersForGoals = fetchMetrikaCountersForGoals
            return this
        }

        fun withIsFromStrategyOperation(isFromStrategyOperation: Boolean): Builder {
            this.isFromStrategyOperation = isFromStrategyOperation
            return this
        }

        fun withAllowAllGoalsOptimizationForOldCampaigns(isAllowAllGoalsOptimizationForOldCampaigns: Boolean): Builder {
            this.isAllowAllGoalsOptimizationForOldCampaigns = isAllowAllGoalsOptimizationForOldCampaigns
            return this
        }

        fun withIsCheckStrategyForMeaninfulGoalsGoalId(isCheckStrategyForMeaninfulGoalsGoalId: Boolean): Builder {
            this.isCheckStrategyForMeaninfulGoalsGoalId = isCheckStrategyForMeaninfulGoalsGoalId
            return this
        }

        fun withAutoApply(isAutoApply: Boolean): Builder {
            this.isAutoApply = isAutoApply
            return this
        }

        fun build(): CampaignOptions {
            return CampaignOptions(
                isCopy, isCopyInOneClient, skipValidateMobileApp, readyToModerate,
                keepModerationStatuses, forceEnableCheckPositionEvent, forceCheckPositionIntervalEvent,
                allowNullDeviceTypeTargeting, allowNullNetworkTargeting,
                allowZeroMobileAppId, requireServicing, limitFioTo255Chars, validateFioForForbiddenChars,
                validateCampaignNameForForbiddenChars, forceValidateAvgCpmMin, sendAutoServicingMailNotification,
                validatePayForConversionExtendedModeEnabled, validatePayForConversionInAutobudgetAvgCpaPerFilter,
                checkDisableAllGoalsOptimizationForDnaFeature, fetchMetrikaCountersForGoals, isFromStrategyOperation,
                isAllowAllGoalsOptimizationForOldCampaigns, isCheckStrategyForMeaninfulGoalsGoalId, isAutoApply
            )
        }
    }
}
