package ru.yandex.direct.core.entity.campaign.service;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public class CampaignStrategyConstants {
    public static final int BOUNDARY_NUMBER_OF_CONVERSIONS_PER_PERIOD = 10;
    public static final int NUM_OF_DAYS_FOR_CONVERSION_LOOK_UP = 7;


    public static final List<AdGroupType> AD_GROUP_TYPES_TO_UPDATE_CPM_RETARGETINGS_ON_ENABLING_AUTOBUDGET = List.of(
            AdGroupType.CPM_BANNER,
            AdGroupType.CPM_VIDEO,
            AdGroupType.CPM_OUTDOOR,
            AdGroupType.CPM_YNDX_FRONTPAGE,
            AdGroupType.CPM_INDOOR,
            AdGroupType.CPM_AUDIO
    );

    public static final Set<? extends ModelProperty<StrategyData, ? extends Serializable>>
            AVAILABLE_PROPERTIES_FOR_SIMPLE_STRATEGY = Set.of(
            StrategyData.NAME,
            StrategyData.GOAL_ID,
            StrategyData.SUM,
            StrategyData.AVG_CPA,
            StrategyData.PAY_FOR_CONVERSION,
            StrategyData.LAST_BIDDER_RESTART_TIME,
            StrategyData.VERSION);

    public static final Set<String> AVAILABLE_STRATEGY_NAMES_FOR_SIMPLE_STRATEGY = Set.of(
            StrategyName.toSource(StrategyName.AUTOBUDGET).getLiteral(),
            StrategyName.toSource(StrategyName.AUTOBUDGET_AVG_CPA).getLiteral()
    );

    public static final Set<StrategyName> AUTOBUDGET_STRATEGIES = Set.of(
            StrategyName.AUTOBUDGET,
            StrategyName.AUTOBUDGET_MEDIA,
            StrategyName.AUTOBUDGET_WEEK_BUNDLE,
            StrategyName.AUTOBUDGET_AVG_CLICK,
            StrategyName.AUTOBUDGET_AVG_CPA,
            StrategyName.AUTOBUDGET_AVG_CPV,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER,
            StrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP,
            StrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER,
            StrategyName.AUTOBUDGET_AVG_CPI,
            StrategyName.AUTOBUDGET_ROI,
            StrategyName.AUTOBUDGET_MAX_REACH,
            StrategyName.AUTOBUDGET_MAX_IMPRESSIONS,
            StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD,
            StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD,
            StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD,
            StrategyName.AUTOBUDGET_CRR
    );

    public static final Set<StrategyName> CPA_STRATEGIES = Set.of(
            StrategyName.AUTOBUDGET_AVG_CPA,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP,
            StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER
    );

    private CampaignStrategyConstants() {
    }

}
