package ru.yandex.direct.core.entity.campaign.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.adgroup.model.CampaignContainsAdGroups;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между группами объявлений и кампаниями
 */
@ParametersAreNonnullByDefault
@Service
public class CampaignWithAdGroupsService implements RelationshipService<CampaignContainsAdGroups, Long, Long> {
    private ShardHelper shardHelper;
    private AdGroupRepository adGroupRepository;

    @Autowired
    public CampaignWithAdGroupsService(ShardHelper shardHelper, AdGroupRepository adGroupRepository) {
        this.shardHelper = shardHelper;
        this.adGroupRepository = adGroupRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> campaignIds) {
        var shard = shardHelper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(adGroupRepository.getAdGroupIdsByCampaignIds(shard, campaignIds).values())
                .flatMap(StreamEx::of)
                .toSet();
    }
}
