package ru.yandex.direct.core.entity.campaign.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaCampaignRepository;
import ru.yandex.direct.core.entity.retargeting.model.CampMetrikaGoalId;
import ru.yandex.direct.core.entity.retargeting.model.CampaignContainsMetrikaGoals;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между кампаниями и целями на кампании (таблица camp_metrika_goals)
 */
@Service
@ParametersAreNonnullByDefault
public class CampaignWithMetrikaGoalsService
        implements RelationshipService<CampaignContainsMetrikaGoals, Long, CampMetrikaGoalId> {
    private final ShardHelper shardHelper;
    private final MetrikaCampaignRepository metrikaCampaignRepository;

    @Autowired
    public CampaignWithMetrikaGoalsService(ShardHelper shardHelper,
                                           MetrikaCampaignRepository metrikaCampaignRepository) {
        this.shardHelper = shardHelper;
        this.metrikaCampaignRepository = metrikaCampaignRepository;
    }

    @Override
    public Set<CampMetrikaGoalId> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId,
                                                               Set<Long> parentIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return metrikaCampaignRepository.getCampMetrikaGoalIdsByCampaignIds(shard, clientId, parentIds);
    }
}
