package ru.yandex.direct.core.entity.campaign.service;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.vcard.model.CampaignContainsVcards;
import ru.yandex.direct.core.entity.vcard.repository.VcardRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между визитками и кампаниями
 */
@ParametersAreNonnullByDefault
@Service
public class CampaignWithVcardsService implements RelationshipService<CampaignContainsVcards, Long, Long> {
    private final ShardHelper shardHelper;
    private final VcardRepository vcardRepository;

    @Autowired
    public CampaignWithVcardsService(ShardHelper shardHelper, VcardRepository vcardRepository) {
        this.shardHelper = shardHelper;
        this.vcardRepository = vcardRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> campaignIds) {
        var shard = shardHelper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(vcardRepository.getVcardIdsByCampaignIds(shard, campaignIds).values())
                .flatMap(Collection::stream)
                .toSet();
    }
}
