package ru.yandex.direct.core.entity.campaign.service;

import java.math.BigDecimal;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface MailTranslations extends TranslationBundle {
    MailTranslations INSTANCE = I18NBundle.implement(MailTranslations.class);

    @TranslationStub("Независимое управление для разных типов площадок")
    Translatable strategyBoth();

    @TranslationStub("На поиске")
    Translatable search();

    @TranslationStub("В сетях")
    Translatable net();

    @TranslationStub("Показы отключены")
    Translatable stop();

    @MessageFormatStub("Изменены параметры стратегии «{0}»")
    Translatable strategyParamChanged(String name);

    @MessageFormatStub("Включена стратегия «{0}»")
    Translatable strategyOn(String name);

    @MessageFormatStub("Максимальная конверсия по цели: \"{0}\"")
    Translatable maximumGoal(String name);

    @TranslationStub("Максимальная конверсия по всем целям")
    Translatable maximumGoals();

    @MessageFormatStub("Тратить {0} в неделю при максимальной ставке {1}")
    Translatable spentMax(String sum, String maxBid);

    @MessageFormatStub("Тратить {0} в неделю")
    Translatable spentWeekly(String sum);

    @MessageFormatStub("Привлекать {0} кликов в неделю при максимальной ставке {1}")
    Translatable clicksWeeklyMax(Long limit, String sum);

    @MessageFormatStub("Привлекать {0} кликов в неделю при средней цене клика {1}")
    Translatable clicksWeeklyAvg(Long limit, String sum);

    @MessageFormatStub("Привлекать {0} кликов в неделю")
    Translatable clicksWeekly(Long limit);

    @MessageFormatStub("Удерживать цену клика {0} в среднем за неделю при недельном бюджете не более {1}")
    Translatable holdPriceInBudget(String price, String budget);

    @MessageFormatStub("Удерживать цену клика {0} в среднем за неделю")
    Translatable holdPrice(String price);

    @MessageFormatStub("Удерживать рентабельность инвестиций за неделю на уровне {0}")
    Translatable holdProfitability(BigDecimal roiCoef);

    @MessageFormatStub("по цели: {0}")
    Translatable goal(Long goalId);

    @MessageFormatStub("по всем целям")
    Translatable goals();

    @MessageFormatStub("возвращать в рекламу {0}% сэкономленного бюджета")
    Translatable reverseReturn(Long percent);

    @MessageFormatStub("при недельном бюджете не более {0}")
    Translatable weekBudget(String sum);

    @MessageFormatStub("при максимальной ставке не более {0}")
    Translatable maxBid(String sum);

    @MessageFormatStub( "учитывать, что {0}% доходов является себестоимостью товаров или услуг")
    Translatable percent(BigDecimal sum);

    @MessageFormatStub("не указана")
    Translatable valueNotSpecified();

}
