package ru.yandex.direct.core.entity.campaign.service;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;



public interface StrategyNameTranslations extends TranslationBundle {
    StrategyNameTranslations INSTANCE = I18NBundle.implement(StrategyNameTranslations.class);

    @TranslationStub("Наивысшая доступная позиция")
    Translatable defaultStub();

    @TranslationStub("Показ под результатами поиска")
    Translatable minPrice();

    @TranslationStub("Показ под результатами поиска на наивысшей доступной позиции")
    Translatable noPremium();

    @TranslationStub("Недельный бюджет")
    Translatable autobudget();

    @TranslationStub("Автобюджет")
    Translatable autobudgetMedia();

    @TranslationStub("Недельный пакет кликов")
    Translatable autobudgetWeekBundle();

    @TranslationStub("Средняя цена клика (за неделю)")
    Translatable autobudgetAvgClick();

    @TranslationStub("Средняя цена конверсии (за неделю)")
    Translatable autobudgetAvgCpa();

    @TranslationStub("Средняя цена просмотра (за неделю)")
    Translatable autobudgetAvgCpv();

    @TranslationStub("Средняя цена просмотра с произвольным периодом")
    Translatable autobudgetAvgCpvCustomPeriod();

    @TranslationStub("Оптимизация средней цены конверсии по всей кампании")
    Translatable autobudgetAvgCpaPerCamp();

    @TranslationStub("Оптимизация средней цены конверсии по фильтру")
    Translatable autobudgetAvgCpaPerFilter();

    @TranslationStub("Оптимизация средней цены клика по всей кампании")
    Translatable autobudgetAvgCpcPerCamp();

    @TranslationStub("Оптимизация средней цены клика по фильтру")
    Translatable autobudgetAvgCpcPerFilter();

    @TranslationStub("Средняя цена установки")
    Translatable autobudgetAvgCpi();

    @TranslationStub("Рентабельность рекламы")
    Translatable autobudgetRoi();

    @TranslationStub("Ручное управление ставками")
    Translatable cpmDefault();

    @TranslationStub("Снижение цены повторных показов")
    Translatable autobudgetMaxReach();

    @TranslationStub("Максимум показов по минимальной цене")
    Translatable autobudgetMaxImpressions();

    @TranslationStub("Снижение цены повторных показов с произвольным периодом")
    Translatable autobudgetMaxReachCustomPeriod();

    @TranslationStub("Максимум показов по минимальной цене с произвольным периодом")
    Translatable autobudgetMaxImpressionsCustomPeriod();

    @TranslationStub("Фиксированные ставка и бюджет на период")
    Translatable periodFixBid();
}
