package ru.yandex.direct.core.entity.campaign.service;

import java.util.EnumMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.common.util.LocaleGuard;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.Translatable;

import static ru.yandex.direct.core.entity.campaign.model.StrategyName.DEFAULT_;
import static ru.yandex.direct.core.entity.campaign.model.StrategyName.MIN_PRICE;
import static ru.yandex.direct.core.entity.campaign.model.StrategyName.NO_PREMIUM;

@Service
public class StrategyTranslationService {
    private final TranslationService translationService;

    private static final StrategyNameTranslations TRANSLATIONS = StrategyNameTranslations.INSTANCE;

    @Autowired
    public StrategyTranslationService(TranslationService translationService) {
        this.translationService = translationService;
    }

    private static final Map<StrategyName, Translatable> TRANSLATABLE_MAP = new EnumMap<>(StrategyName.class);
    static {
        TRANSLATABLE_MAP.put(DEFAULT_, TRANSLATIONS.defaultStub());
        TRANSLATABLE_MAP.put(MIN_PRICE, TRANSLATIONS.minPrice());
        TRANSLATABLE_MAP.put(NO_PREMIUM, TRANSLATIONS.noPremium());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET, TRANSLATIONS.autobudget());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_MEDIA, TRANSLATIONS.autobudgetMedia());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_WEEK_BUNDLE, TRANSLATIONS.autobudgetWeekBundle());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CLICK, TRANSLATIONS.autobudgetAvgClick());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPA, TRANSLATIONS.autobudgetAvgCpa());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPV, TRANSLATIONS.autobudgetAvgCpv());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD, TRANSLATIONS.autobudgetAvgCpvCustomPeriod());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP, TRANSLATIONS.autobudgetAvgCpaPerCamp());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER, TRANSLATIONS.autobudgetAvgCpaPerFilter());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP, TRANSLATIONS.autobudgetAvgCpcPerCamp());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER, TRANSLATIONS.autobudgetAvgCpcPerFilter());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_AVG_CPI, TRANSLATIONS.autobudgetAvgCpi());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_ROI, TRANSLATIONS.autobudgetRoi());
        TRANSLATABLE_MAP.put(StrategyName.CPM_DEFAULT, TRANSLATIONS.cpmDefault());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_MAX_REACH, TRANSLATIONS.autobudgetMaxReach());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_MAX_IMPRESSIONS, TRANSLATIONS.autobudgetMaxImpressions());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD,
                TRANSLATIONS.autobudgetMaxReachCustomPeriod());
        TRANSLATABLE_MAP.put(StrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD,
                TRANSLATIONS.autobudgetMaxImpressionsCustomPeriod());
        TRANSLATABLE_MAP.put(StrategyName.PERIOD_FIX_BID, TRANSLATIONS.periodFixBid());
    }

    public String getTranslation(StrategyName strategyName) {
        Translatable translatable = TRANSLATABLE_MAP.get(strategyName);
        if (translatable == null) {
            return null;
        }
        return translationService.translate(translatable);
    }

    public String getRussianTranslation(StrategyName strategyName) {
        try (LocaleGuard ignored = LocaleGuard.fromLanguage(Language.RU)) {
            return getTranslation(strategyName);
        }
    }
}
