@file:JvmName("WalletUtils")

package ru.yandex.direct.core.entity.campaign.service

import java.math.BigDecimal

fun calcSumTotalIncludingOverdraft(
    campaignSum: BigDecimal,
    campaignSumSpent: BigDecimal,
    walletSum: BigDecimal?,
    autoOverdraftAddition: BigDecimal?,
): BigDecimal {
    var sumTotal: BigDecimal = campaignSum - campaignSumSpent
    if (walletSum != null) {
        // сумма на ОС уже учитывает перетраты на всех кампаниях(включая текущую)
        // поэтому перетрата по текущей кампании игнорируется
        sumTotal = walletSum + sumTotal.coerceAtLeast(BigDecimal.ZERO)

        // Если есть добавка по автоовердрафтам, учитываем её
        if (autoOverdraftAddition != null && autoOverdraftAddition > BigDecimal.ZERO) {
            sumTotal += autoOverdraftAddition
        }
    }
    return sumTotal
}
