package ru.yandex.direct.core.entity.campaign.service.accesschecker;

import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds;
import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefects.adGroupTypeNotSupported;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.actionInArchivedCampaign;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.adGroupNotFound;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.adGroupNotSupported;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.adNotFound;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.inconsistentBannerType;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.unsupportedBannerType;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.archivedCampaignModification;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.campaignNoRights;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.campaignNotFound;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.campaignTypeNotSupported;
import static ru.yandex.direct.core.validation.defects.RightsDefects.noRights;

public class AccessDefectPresets {
    public static final CampaignAccessDefects DEFAULT_DEFECTS = new CampaignAccessDefects.Builder()
            .withTypeNotAllowable(campaignNotFound())
            .withNotVisible(campaignNotFound())
            .withTypeNotSupported(objectId -> campaignTypeNotSupported())
            .withNoRights(objectId -> campaignNoRights())
            .withArchivedModification(objectId -> archivedCampaignModification())
            .build();
    public static final CampaignAccessDefects AD_ACCESS_DEFECTS = DEFAULT_DEFECTS.toBuilder()
            .withTypeNotAllowable(inconsistentBannerType())
            .withNotVisible(adNotFound())
            .withTypeNotSupported(unsupportedBannerType())
            .withArchivedModification(archivedCampaignModification())
            .build();
    /**
     * Мапинг дефектов для проверки групп у баннеров
     */
    @SuppressWarnings("WeakerAccess")
    public static final CampaignAccessDefects AD_GROUP_ACCESS_DEFECTS_FOR_RETARGETING = DEFAULT_DEFECTS.toBuilder()
            .withTypeNotAllowable(RetargetingDefects::adGroupNotFound)
            .withNotVisible(RetargetingDefects::adGroupNotFound)
            .withTypeNotSupported(adGroupTypeNotSupported())
            .build();
    /**
     * Мапинг дефектов для проверки групп у баннеров
     */
    public static final CampaignAccessDefects AD_GROUP_ACCESS_DEFECTS_FOR_BANNER = DEFAULT_DEFECTS.toBuilder()
            .withTypeNotSupported(adGroupNotSupported())
            .withTypeNotAllowable(adGroupNotFound())
            .withNotVisible(adGroupNotFound())
            .withNoRights(noRights())
            .withArchivedModification(actionInArchivedCampaign())
            .build();
    @SuppressWarnings("WeakerAccess")
    public static final CampaignAccessDefects BID_MODIFIER_ACCESS_DEFECTS = DEFAULT_DEFECTS.toBuilder()
            .withTypeNotAllowable(new Defect<>(BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND))
            .withNotVisible(new Defect<>(BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND))
            .build();
}
