package ru.yandex.direct.core.entity.campaign.service.accesschecker;

import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheck;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Интерфейс класса, ответственного за проверку доступности кампании
 * Проверяет кампанию на доступность, поддерживаемость
 * Позволяет построить фильтр для выборки подходящих кампаний из базы
 */
public interface CampaignAccessibiltyChecker<T extends CampaignForAccessCheck> {
    boolean isEditable(T campaign);

    boolean isAllowable(T campaign);

    CampaignForAccessCheckRepositoryAdapter<T> toAllowableCampaignsRepositoryAdapter(ClientId clientId);

    CampaignForAccessCheckRepositoryAdapter<T> toAllCampaignsRepositoryAdapter(ClientId clientId);
}
