package ru.yandex.direct.core.entity.campaign.service.accesschecker;

import java.util.function.Function;

import ru.yandex.direct.core.entity.campaign.container.AffectedCampaignIdsContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignAccessType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

/**
 * Проверяет доступность кампаний или подобъектов (группы, баннеры...) с помощью CampaignSubObjectAccessChecker
 */
public class CampaignSubObjectAccessValidator implements Validator<Long, Defect> {
    static final CampaignAccessDefects ACCESS_DEFECTS = AccessDefectPresets.DEFAULT_DEFECTS;

    private final CampaignSubObjectAccessConstraint accessConstraint;

    CampaignSubObjectAccessValidator(CampaignSubObjectAccessChecker checker,
                                     CampaignAccessType desiredAccess,
                                     AffectedCampaignIdsContainer affectedCampaignIdsContainer) {
        this(
                new CampaignSubObjectAccessConstraint(
                        checker,
                        Function.identity(),
                        ACCESS_DEFECTS,
                        desiredAccess,
                        affectedCampaignIdsContainer));
    }

    CampaignSubObjectAccessValidator(CampaignSubObjectAccessChecker checker,
                                     CampaignAccessType desiredAccess,
                                     CampaignAccessDefects accessDefects,
                                     AffectedCampaignIdsContainer affectedCampaignIdsContainer) {
        this(
                new CampaignSubObjectAccessConstraint(
                        checker,
                        Function.identity(),
                        accessDefects,
                        desiredAccess,
                        affectedCampaignIdsContainer));
    }

    CampaignSubObjectAccessValidator(CampaignSubObjectAccessConstraint accessConstraint) {
        this.accessConstraint = accessConstraint;
    }

    public CampaignSubObjectAccessConstraint getAccessConstraint() {
        return accessConstraint;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long objectId) {
        ItemValidationBuilder<Long, Defect> vb = ItemValidationBuilder.of(objectId);
        vb.check(notNull())
                .check(accessConstraint);
        return vb.getResult();
    }
}
