package ru.yandex.direct.core.entity.campaign.service.accesschecker;

import java.util.Collection;
import java.util.Map;

import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheck;

@FunctionalInterface
public interface CampaignSubObjectRetriever<T extends CampaignForAccessCheck> {
    /**
     * Получить отображение идентификатора под-объекта в CampaignForAccessCheck.
     * В качестве под-объекта может быть и сама кампания и любые принадлежащие её объекты: группы, объявления и т.п.
     *
     * @param objectIds коллекция идентификаторов под-объектов кампании для которых нужно получить
     *                  CampaignForAccessCheck
     * @return отображение идентификатора под-объекта в CampaignForAccessCheck
     */
    Map<Long, T> get(int shard,
                     CampaignForAccessCheckRepositoryAdapter<T> campaignForAccessCheckRepositoryAdapter,
                     Collection<Long> objectIds);
}
