package ru.yandex.direct.core.entity.campaign.service.accesschecker;

import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheck;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.api5.Api5CampaignAccessibilityChecker;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.core.AllowedTypesCampaignAccessibilityChecker;

public class RequestCampaignAccessibilityCheckerProvider {
    private CampaignAccessibiltyChecker<? extends CampaignForAccessCheck> accessibiltyChecker;

    public RequestCampaignAccessibilityCheckerProvider() {
        accessibiltyChecker = AllowedTypesCampaignAccessibilityChecker.ALL;
    }

    public CampaignAccessibiltyChecker<? extends CampaignForAccessCheck> get() {
        return accessibiltyChecker;
    }

    public void setApi5() {
        accessibiltyChecker = Api5CampaignAccessibilityChecker.getApi5AccessibilityChecker();
    }

    public void setCustom(CampaignAccessibiltyChecker<? extends CampaignForAccessCheck> custom) {
        accessibiltyChecker = custom;
    }
}
