package ru.yandex.direct.core.entity.campaign.service.accesschecker.api5;

import java.util.Collection;

import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheck;
import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheckApiImpl;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignForAccessCheckRepositoryAdapter;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

abstract class AbstractApi5AccessCheckRepositoryAdapter implements
        CampaignForAccessCheckRepositoryAdapter<CampaignForAccessCheckApiImpl> {
    private static final JooqMapperWithSupplier<CampaignForAccessCheckApiImpl> campaignForAccessCheckMapper =
            JooqMapperWithSupplierBuilder.builder(CampaignForAccessCheckApiImpl::new)
                    .map(property(CampaignForAccessCheck.ID, CAMPAIGNS.CID))
                    .map(convertibleProperty(CampaignForAccessCheck.ARCHIVED, CAMPAIGNS.ARCHIVED,
                            CampaignMappings::archivedFromDb,
                            CampaignMappings::archivedToDb))
                    .map(convertibleProperty(CampaignForAccessCheckApiImpl.TYPE, CAMPAIGNS.TYPE,
                            CampaignType::fromSource,
                            CampaignType::toSource))
                    .readProperty(CampaignForAccessCheckApiImpl.IS_UNIVERSAL,
                            fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isUniversalFromDb))
                    .map(convertibleProperty(CampaignForAccessCheckApiImpl.SOURCE, CAMPAIGNS.SOURCE,
                            CampaignSource::fromSource,
                            CampaignSource::toSource))
                    .build();
    private static final Collection<Field<?>> campaignForAccessCheckFields =
            campaignForAccessCheckMapper.getFieldsToRead();

    @Override
    public Collection<Field<?>> campaignForAccessCheckFields() {
        return campaignForAccessCheckFields;
    }

    @Override
    public RecordMapper<Record, CampaignForAccessCheckApiImpl> recordMapper() {
        return campaignForAccessCheckMapper::fromDb;
    }
}
