package ru.yandex.direct.core.entity.campaign.service.accesschecker.api5;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereEqFilter;

class AllClientCampaignsApi5AccessCheckRepositoryAdapter extends AbstractApi5AccessCheckRepositoryAdapter {
    private final ClientId clientId;

    public AllClientCampaignsApi5AccessCheckRepositoryAdapter(ClientId clientId) {
        this.clientId = clientId;
    }

    @Override
    public Filter campaignForAccessCheckFilter() {
        return whereEqFilter(CAMPAIGNS.CLIENT_ID, clientId.asLong());
    }
}
