package ru.yandex.direct.core.entity.campaign.service.accesschecker.core;

import java.util.Collection;

import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;

import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheck;
import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheckDefaultImpl;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignForAccessCheckRepositoryAdapter;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

abstract class AbstractAllowedTypesAccessCheckRepositoryAdapter implements
        CampaignForAccessCheckRepositoryAdapter<CampaignForAccessCheckDefaultImpl> {
    private static final JooqMapperWithSupplier<CampaignForAccessCheckDefaultImpl> campaignForAccessCheckMapper =
            JooqMapperWithSupplierBuilder.builder(CampaignForAccessCheckDefaultImpl::new)
            .map(property(CampaignForAccessCheck.ID, CAMPAIGNS.CID))
            .map(convertibleProperty(CampaignForAccessCheck.ARCHIVED, CAMPAIGNS.ARCHIVED,
                    CampaignMappings::archivedFromDb,
                    CampaignMappings::archivedToDb))
            .map(convertibleProperty(CampaignForAccessCheckDefaultImpl.TYPE, CAMPAIGNS.TYPE,
                    CampaignType::fromSource,
                    CampaignType::toSource))
            .map(convertibleProperty(CampaignForAccessCheckDefaultImpl.SOURCE, CAMPAIGNS.SOURCE,
                    CampaignSource::fromSource,
                    CampaignSource::toSource))
            .build();
    private static final Collection<Field<?>> campaignForAccessCheckFields =
            campaignForAccessCheckMapper.getFieldsToRead();

    @Override
    public Collection<Field<?>> campaignForAccessCheckFields() {
        return campaignForAccessCheckFields;
    }

    @Override
    public RecordMapper<Record, CampaignForAccessCheckDefaultImpl> recordMapper() {
        return campaignForAccessCheckMapper::fromDb;
    }
}
