package ru.yandex.direct.core.entity.campaign.service.accesschecker.core;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereEqFilter;

public class AllClientCampaignsDefaultAccessCheckRepositoryAdapter
        extends AbstractAllowedTypesAccessCheckRepositoryAdapter {
    private final ClientId clientId;

    public AllClientCampaignsDefaultAccessCheckRepositoryAdapter(ClientId clientId) {
        this.clientId = clientId;
    }

    @Override
    public Filter campaignForAccessCheckFilter() {
        return whereEqFilter(CAMPAIGNS.CLIENT_ID, clientId.asLong());
    }
}
