package ru.yandex.direct.core.entity.campaign.service.accesschecker.core;

import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.multipleConditionFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereEqFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AllowableCampaignsDefaultAccessCheckRepositoryAdapter
        extends AbstractAllowedTypesAccessCheckRepositoryAdapter {
    private final ClientId clientId;
    private final Set<CampaignType> allowableTypes;
    private final Set<CampaignSource> allowableSources;

    public AllowableCampaignsDefaultAccessCheckRepositoryAdapter(
            ClientId clientId,
            Set<CampaignType> allowableTypes,
            Set<CampaignSource> allowableSources) {
        this.clientId = clientId;
        this.allowableTypes = allowableTypes;
        this.allowableSources = allowableSources;
    }

    @Override
    public Filter campaignForAccessCheckFilter() {
        return multipleConditionFilter(
                whereEqFilter(CAMPAIGNS.CLIENT_ID, clientId.asLong()),
                whereInFilter(CAMPAIGNS.TYPE, mapList(allowableTypes, CampaignType::toSource)),
                whereInFilter(CAMPAIGNS.SOURCE, mapList(allowableSources, CampaignSource::toSource))
        );
    }
}
