package ru.yandex.direct.core.entity.campaign.service.accesschecker.core;

import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.campaign.model.CampaignForAccessCheckDefaultImpl;
import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignTypeKinds;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.AbstractCampaignAccessibiltyChecker;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignForAccessCheckRepositoryAdapter;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.campaign.model.CampaignSourceUtils.ALL_CAMPAIGN_SOURCES;

/**
 * Имплементация CampaignAccessibiltyChecker, проверяющая кампанию по доступности типа
 */
public class AllowedTypesCampaignAccessibilityChecker extends AbstractCampaignAccessibiltyChecker<CampaignForAccessCheckDefaultImpl> {

    private static final Set<CampaignType> CAMPAIGN_TYPES_UNDER_DEVELOPMENT = new ImmutableSet.Builder<CampaignType>()
            .addAll(CampaignTypeKinds.ALL)
            .build();

    public static final AllowedTypesCampaignAccessibilityChecker ALL = new AllowedTypesCampaignAccessibilityChecker(
            CAMPAIGN_TYPES_UNDER_DEVELOPMENT, CAMPAIGN_TYPES_UNDER_DEVELOPMENT,
            ALL_CAMPAIGN_SOURCES, ALL_CAMPAIGN_SOURCES);

    public AllowedTypesCampaignAccessibilityChecker(
            Set<CampaignType> supportedTypes, Set<CampaignType> allowableTypes,
            Set<CampaignSource> editableSources, Set<CampaignSource> visibleSources) {
        super(supportedTypes, allowableTypes, editableSources, visibleSources);
    }

    @Override
    public CampaignForAccessCheckRepositoryAdapter<CampaignForAccessCheckDefaultImpl> toAllowableCampaignsRepositoryAdapter(ClientId clientId) {
        return new AllowableCampaignsDefaultAccessCheckRepositoryAdapter(clientId, allowableTypes, allowableSources);
    }

    @Override
    public CampaignForAccessCheckRepositoryAdapter<CampaignForAccessCheckDefaultImpl> toAllCampaignsRepositoryAdapter(ClientId clientId) {
        return new AllClientCampaignsDefaultAccessCheckRepositoryAdapter(clientId);
    }
}
