package ru.yandex.direct.core.entity.campaign.service.type;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public abstract class AbstractRestrictedCampaignsOperationContainer implements RestrictedCampaignsOperationContainer {

    private final int shard;
    private final Long operatorUid;
    private final ClientId clientId;
    private final Long clientUid;
    private final Long chiefUid;
    protected final CampaignOptions options;
    private final RequestBasedMetrikaClientAdapter metrikaClient;
    private final Map<Long, BaseStrategy> clientStrategiesToLinkToAndCampaignsOldStrategiesById;
    private final DisabledFieldsDataContainer disabledDataContainer;

    public AbstractRestrictedCampaignsOperationContainer(int shard, Long operatorUid, ClientId clientId, Long clientUid,
                                                         Long chiefUid, CampaignOptions options,
                                                         RequestBasedMetrikaClientAdapter metrikaClient,
                                                         Map<Long, BaseStrategy> clientStrategiesToLinkToAndCampaignsOldStrategiesById,
                                                         DisabledFieldsDataContainer disabledDataContainer) {
        this.shard = shard;
        this.operatorUid = operatorUid;
        this.clientId = clientId;
        this.clientUid = clientUid;
        this.chiefUid = chiefUid;
        this.options = options;
        this.metrikaClient = metrikaClient;
        this.clientStrategiesToLinkToAndCampaignsOldStrategiesById =
                clientStrategiesToLinkToAndCampaignsOldStrategiesById;
        this.disabledDataContainer = disabledDataContainer;
    }

    @Override
    public int getShard() {
        return shard;
    }

    @Override
    public Long getOperatorUid() {
        return operatorUid;
    }

    @Override
    public ClientId getClientId() {
        return clientId;
    }

    @Override
    public Long getClientUid() {
        return clientUid;
    }

    @Override
    public Long getChiefUid() {
        return chiefUid;
    }

    @Override
    public CampaignOptions getOptions() {
        return options;
    }

    @Override
    public RequestBasedMetrikaClientAdapter getMetrikaClient() {
        return metrikaClient;
    }

    @Override
    public BaseStrategy getPackageStrategy(Long strategyId) {
        return clientStrategiesToLinkToAndCampaignsOldStrategiesById.get(strategyId);
    }

    @Override
    public DisabledFieldsDataContainer getDisabledFieldsInfoContainer() {
        return disabledDataContainer;
    }
}
