package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.multitype.service.type.add.AddOperationTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class CampaignAddOperationSupportFacade extends AddOperationTypeSupportFacade<BaseCampaign,
        RestrictedCampaignsAddOperationContainer, CampaignAdditionalActionsContainer> {

    private final CampaignRepository campaignRepository;

    @Autowired
    public CampaignAddOperationSupportFacade(List<CampaignAddOperationSupport<? extends BaseCampaign>> supports,
                                             CampaignRepository campaignRepository) {
        super(supports);
        this.campaignRepository = campaignRepository;
    }

    @Override
    public void afterExecution(RestrictedCampaignsAddOperationContainer addContainer,
                               List<? extends BaseCampaign> models) {
        super.afterExecution(addContainer, models);
        var cids = models.stream().map(BaseCampaign::getId).collect(Collectors.toList());
        campaignRepository.setCampaignsFinished(addContainer.getShard(), cids);
    }
}
