package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstantsService;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAttributionModelAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithAttributionModel> {

    private final CampaignConstantsService campaignConstantsService;

    @Autowired
    public CampaignWithAttributionModelAddOperationSupport(CampaignConstantsService campaignConstantsService) {
        this.campaignConstantsService = campaignConstantsService;
    }

    @Override
    public Class<CampaignWithAttributionModel> getTypeClass() {
        return CampaignWithAttributionModel.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithAttributionModel> campaigns) {
        campaigns.forEach(campaign -> campaign.setAttributionModel(
                nvl(campaign.getAttributionModel(), campaignConstantsService.getDefaultAttributionModel())));
    }
}
