package ru.yandex.direct.core.entity.campaign.service.type.add

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBannerHrefParams
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer
import ru.yandex.direct.core.entity.campaign.service.type.utils.BannerHrefParamsUtils.sanitizeHrefParams

@Component
class CampaignWithBannerHrefParamsTypesAddOperationSupport :
    AbstractCampaignAddOperationSupport<CampaignWithBannerHrefParams>() {
    override fun getTypeClass(): Class<CampaignWithBannerHrefParams> = CampaignWithBannerHrefParams::class.java

    override fun onPreValidated(
        addContainer: RestrictedCampaignsAddOperationContainer,
        campaigns: MutableList<CampaignWithBannerHrefParams>
    ) {
        campaigns.forEach {
            it.bannerHrefParams = sanitizeHrefParams(it.bannerHrefParams)
        }
    }
}
