package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBidModifiers;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.CampaignWithBidModifiersUtils;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBidModifiersAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithBidModifiers> {
    @Override
    public Class<CampaignWithBidModifiers> getTypeClass() {
        return CampaignWithBidModifiers.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
            List<CampaignWithBidModifiers> models) {
        models.forEach(CampaignWithBidModifiersAddOperationSupport::enrichBidModifiersIfNeeded);
    }

    private static void enrichBidModifiersIfNeeded(CampaignWithBidModifiers campaignWithBidModifiers) {
        if (campaignWithBidModifiers.getType() != CampaignType.CPM_BANNER) {
            return;
        }
        CampaignWithBidModifiersUtils.addInBannerToInAppBidModifiers(campaignWithBidModifiers.getBidModifiers());

    }


}
