package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety;
import ru.yandex.direct.core.entity.campaign.service.CampaignWithBrandSafetyService;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.DEFAULT_BRAND_SAFETY_CATEGORIES;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBrandSafetyAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithBrandSafety> {

    private final CampaignWithBrandSafetyService campaignWithBrandSafetyService;

    @Autowired
    public CampaignWithBrandSafetyAddOperationSupport(CampaignWithBrandSafetyService campaignWithBrandSafetyService) {
        this.campaignWithBrandSafetyService = campaignWithBrandSafetyService;
    }

    @Override
    public Class<CampaignWithBrandSafety> getTypeClass() {
        return CampaignWithBrandSafety.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithBrandSafety> campaigns) {
        campaigns.forEach(campaign -> campaign.setBrandSafetyCategories(
                nvl(campaign.getBrandSafetyCategories(), DEFAULT_BRAND_SAFETY_CATEGORIES)));
    }

    @Override
    public void beforeExecution(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                                List<CampaignWithBrandSafety> campaigns) {
        Map<Long, Long> retCondIdByCampaignId = campaignWithBrandSafetyService.saveCategoriesAndGetRetCondIds(
                addCampaignParametersContainer.getShard(),
                addCampaignParametersContainer.getClientId(),
                campaigns
        );

        campaigns.forEach(campaign ->
                campaign.setBrandSafetyRetCondId(retCondIdByCampaignId.getOrDefault(campaign.getId(), null)));
    }
}
