package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.BroadMatch;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBroadMatchAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithBroadMatch> {
    @Override
    public Class<CampaignWithBroadMatch> getTypeClass() {
        return CampaignWithBroadMatch.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithBroadMatch> campaigns) {
        campaigns.forEach(campaign -> {
            DbStrategy strategy = campaign.getStrategy();
            BroadMatch broadMatch = campaign.getBroadMatch();
            // если стратегия "только на сети" выключаем ДРФ: DIRECT-68661
            if (strategy != null && strategy.isSearchStop() && broadMatch.getBroadMatchFlag()) {
                campaign.getBroadMatch().setBroadMatchFlag(false);
            }
        });
    }

}
