package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithContactInfo;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.core.entity.vcard.service.VcardHelper;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContactInfoAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithContactInfo> {

    private final VcardHelper vcardHelper;

    @Autowired
    public CampaignWithContactInfoAddOperationSupport(VcardHelper vcardHelper) {
        this.vcardHelper = vcardHelper;
    }

    @Override
    public Class<CampaignWithContactInfo> getTypeClass() {
        return CampaignWithContactInfo.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithContactInfo> campaigns) {
        List<CampaignWithContactInfo> campaignWithContactInfo = filterList(campaigns, x -> x.getContactInfo() != null);

        campaignWithContactInfo.forEach(campaign -> enrichContactInfo(addCampaignParametersContainer.getChiefUid(),
                campaign.getContactInfo()));
        List<Vcard> vcards = mapList(campaignWithContactInfo, CampaignWithContactInfo::getContactInfo);
        vcardHelper.fillVcardsWithGeocoderData(vcards);
        vcardHelper.fillVcardsWithRegionIds(vcards);
    }

    private Vcard enrichContactInfo(Long chiefUid, Vcard contactInfo) {
        return contactInfo
                .withUid(chiefUid);
    }
}
