package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCreatingEmptyStatForGoals;
import ru.yandex.direct.core.entity.campaign.service.CampMetrikaGoalsService;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.metrika.container.CampaignTypeWithCounterIds;
import ru.yandex.direct.core.entity.metrika.service.campaigngoals.CampaignGoalsService;
import ru.yandex.direct.core.entity.retargeting.model.Goal;

import static ru.yandex.direct.utils.CollectionUtils.isEmpty;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCreatingEmptyStatForGoalsAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithCreatingEmptyStatForGoals> {

    private final CampMetrikaGoalsService campMetrikaGoalsService;
    private final CampaignGoalsService campaignGoalsService;

    @Autowired
    public CampaignWithCreatingEmptyStatForGoalsAddOperationSupport(
            CampMetrikaGoalsService campMetrikaGoalsService,
            CampaignGoalsService campaignGoalsService) {
        this.campMetrikaGoalsService = campMetrikaGoalsService;
        this.campaignGoalsService = campaignGoalsService;
    }

    @Override
    public Class<CampaignWithCreatingEmptyStatForGoals> getTypeClass() {
        return CampaignWithCreatingEmptyStatForGoals.class;
    }

    @Override
    public void afterExecution(RestrictedCampaignsAddOperationContainer addContainer,
                               List<CampaignWithCreatingEmptyStatForGoals> campaigns) {
        if (addContainer.isCopy()) {
            // при копировании кампании цели копируются в CampMetrikaGoalService как дочерние сущности
            return;
        }

        List<CampaignWithCreatingEmptyStatForGoals> campaignsToAddGoals = filterList(campaigns,
                CampaignWithCreatingEmptyStatForGoalsAddOperationSupport::isCampaignGoalsNeedToAdd);
        if (campaignsToAddGoals.isEmpty()) {
            return;
        }

        Map<Long, CampaignTypeWithCounterIds> campaignTypeWithCounterIdsByCampaignId =
                listToMap(campaigns, CampaignWithCreatingEmptyStatForGoals::getId,
                        campaign -> new CampaignTypeWithCounterIds()
                                .withCampaignType(campaign.getType())
                                .withCounterIds(listToSet(campaign.getMetrikaCounters())));

        var availableGoalsForCampaign =
                campaignGoalsService.getAvailableGoalsForCampaignId(addContainer.getOperatorUid(),
                addContainer.getClientId(),
                campaignTypeWithCounterIdsByCampaignId,
                addContainer.getMetrikaClient()
                );

        var availableGoalsForCampaignByCounterIds = StreamEx.of(availableGoalsForCampaign.values())
                .flatMap(Collection::stream)
                .mapToEntry(Goal::getCounterId, Function.identity())
                .nonNullKeys()
                .mapKeys(Integer::longValue)
                .grouping(Collectors.toSet());

        campMetrikaGoalsService.addCampMetrikaGoals(
                addContainer.getShard(),
                addContainer.getClientId(),
                campaignsToAddGoals,
                availableGoalsForCampaignByCounterIds);
    }

    private static boolean isCampaignGoalsNeedToAdd(CampaignWithCreatingEmptyStatForGoals campaign) {
        return !isEmpty(campaign.getMetrikaCounters());
    }

}
