package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomCheckPositionEventAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithCustomCheckPositionEvent> {
    @Override
    public Class<CampaignWithCustomCheckPositionEvent> getTypeClass() {
        return CampaignWithCustomCheckPositionEvent.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithCustomCheckPositionEvent> campaigns) {
        campaigns
                .forEach(campaign -> CampaignConverter.setFieldIfNull(campaign,
                        CampaignWithCustomCheckPositionEvent.ENABLE_CHECK_POSITION_EVENT,
                        CampaignConstants.DEFAULT_ENABLE_CHECK_POSITION_EVENT));

        campaigns
                .forEach(campaign -> CampaignConverter.setFieldIfNull(campaign,
                        CampaignWithCustomCheckPositionEvent.CHECK_POSITION_INTERVAL_EVENT,
                        CampaignConstants.DEFAULT_CAMPAIGN_CHECK_POSITION_INTERVAL));
    }
}

