package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignDayBudgetNotificationStatus;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomDayBudget;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.utils.NumberUtils;

import static ru.yandex.direct.common.util.RepositoryUtils.NOW_PLACEHOLDER;
import static ru.yandex.direct.feature.FeatureName.PACKAGE_STRATEGIES_STAGE_TWO;
import static ru.yandex.direct.utils.CommonUtils.isValidId;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomDayBudgetAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithCustomDayBudget> {
    @Autowired
    public FeatureService featureService;

    @Override
    public Class<CampaignWithCustomDayBudget> getTypeClass() {
        return CampaignWithCustomDayBudget.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithCustomDayBudget> campaigns) {
        boolean isPackageStrategiesStageTwoEnabled =
                featureService.isEnabledForClientId(addCampaignParametersContainer.getClientId(),
                        PACKAGE_STRATEGIES_STAGE_TWO);
        campaigns.forEach(c -> onPreValidated(c, isPackageStrategiesStageTwoEnabled));
    }

    private void onPreValidated(CampaignWithCustomDayBudget campaign,
                                boolean isPackageStrategiesStageTwoEnabled) {
        campaign.setDayBudgetNotificationStatus(CampaignDayBudgetNotificationStatus.READY);
        campaign.setDayBudgetStopTime(null);

        if (!isCampaignWithPackageStrategyAndStrategyIdIsValid(isPackageStrategiesStageTwoEnabled, campaign)) {
            campaign.setDayBudgetDailyChangeCount(0);

            if (NumberUtils.greaterThanZero(campaign.getDayBudget())) {
                campaign.setDayBudgetLastChange(NOW_PLACEHOLDER);
            }
        }

    }

    private boolean isCampaignWithPackageStrategyAndStrategyIdIsValid(boolean isPackageStrategiesStageTwoEnabled,
                                                                      CampaignWithCustomDayBudget campaign) {
        return isPackageStrategiesStageTwoEnabled
                && campaign instanceof CampaignWithPackageStrategy
                && isValidId(((CampaignWithPackageStrategy) campaign).getStrategyId());
    }
}
