package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledDomainsAndSsp;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler;

import static ru.yandex.direct.utils.CollectionUtils.isEmpty;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledDomainsAndSspAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithDisabledDomainsAndSsp> {
    private final HostingsHandler hostingsHandler;
    private final DisableDomainValidationService disableDomainValidationService;

    @Autowired
    public CampaignWithDisabledDomainsAndSspAddOperationSupport(HostingsHandler hostingsHandler,
                                                                DisableDomainValidationService disableDomainValidationService) {
        this.hostingsHandler = hostingsHandler;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public Class<CampaignWithDisabledDomainsAndSsp> getTypeClass() {
        return CampaignWithDisabledDomainsAndSsp.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithDisabledDomainsAndSsp> campaigns) {

        campaigns.forEach(campaign -> {
            if (!isEmpty(campaign.getDisabledDomains())) {
                campaign.setDisabledDomains(mapList(campaign.getDisabledDomains(), hostingsHandler::stripWww));
            }
            List<String> sspThatAlsoDomains =
                    filterList(campaign.getDisabledSsp(),
                            domain -> disableDomainValidationService.isValidDomain(domain,
                                    addCampaignParametersContainer.getClientId()));
            if (sspThatAlsoDomains != null) {
                if (campaign.getDisabledDomains() == null) {
                    campaign.setDisabledDomains(sspThatAlsoDomains);
                } else {
                    campaign.getDisabledDomains().addAll(sspThatAlsoDomains);
                }
            }
        });
    }
}
