package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledVideoPlacements;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledVideoPlacementsAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithDisabledVideoPlacements> {
    private final HostingsHandler hostingsHandler;

    @Autowired
    public CampaignWithDisabledVideoPlacementsAddOperationSupport(HostingsHandler hostingsHandler) {
        this.hostingsHandler = hostingsHandler;
    }

    @Override
    public Class<CampaignWithDisabledVideoPlacements> getTypeClass() {
        return CampaignWithDisabledVideoPlacements.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithDisabledVideoPlacements> campaigns) {
        campaigns.forEach(campaign -> campaign.setDisabledVideoPlacements(mapList(campaign.getDisabledVideoPlacements(),
                hostingsHandler::stripWww)));
    }

}
