package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisallowedPageIds;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.client.repository.ClientRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisallowedPageIdsAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithDisallowedPageIds>
{
    private final ClientRepository clientRepository;
    private final FeatureService featureService;

    @Autowired
    public CampaignWithDisallowedPageIdsAddOperationSupport(
            ClientRepository clientRepository,
            FeatureService featureService) {
        this.clientRepository = clientRepository;
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithDisallowedPageIds> getTypeClass() {
        return CampaignWithDisallowedPageIds.class;
    }

    @Override
    public void beforeExecution(
            RestrictedCampaignsAddOperationContainer addContainer,
            List<CampaignWithDisallowedPageIds> models)
    {
        super.beforeExecution(addContainer, models);
        if (!featureService.isEnabledForUid(addContainer.getOperatorUid(),
                List.of(FeatureName.SET_CAMPAIGN_DISALLOWED_PAGE_IDS))) {
            Set<ClientId> clientIds = models.stream().map(campaign ->
                    (ClientId.fromLong(((CommonCampaign) campaign).getClientId()))).collect(Collectors.toSet());
            Map<Long, Client> clientsMap = listToMap(clientRepository.getClientData(addContainer.getShard(), clientIds),
                    Client::getClientId);
            models.forEach(campaign -> campaign.setDisallowedPageIds(
                    clientsMap.get(((CommonCampaign) campaign).getClientId()).getDefaultDisallowedPageIds()));
        }
    }
}
